/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.gl.func;

import org.lwjgl.opengl.ARBVertexArrayObject;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GL30;

public enum GlVertexArrayFunctions {
    BASE{

        @Override
        public void glBindVertexArray(int id) {
            GL30.glBindVertexArray((int)id);
        }

        @Override
        public int glGenVertexArrays() {
            return GL30.glGenVertexArrays();
        }

        @Override
        public void glDeleteVertexArrays(int id) {
            GL30.glDeleteVertexArrays((int)id);
        }
    }
    ,
    ARB{

        @Override
        public void glBindVertexArray(int id) {
            ARBVertexArrayObject.glBindVertexArray((int)id);
        }

        @Override
        public int glGenVertexArrays() {
            return ARBVertexArrayObject.glGenVertexArrays();
        }

        @Override
        public void glDeleteVertexArrays(int id) {
            ARBVertexArrayObject.glDeleteVertexArrays((int)id);
        }
    }
    ,
    UNSUPPORTED{

        @Override
        public void glBindVertexArray(int id) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int glGenVertexArrays() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void glDeleteVertexArrays(int id) {
            throw new UnsupportedOperationException();
        }
    };


    static GlVertexArrayFunctions load(ContextCapabilities capabilities) {
        if (capabilities.OpenGL30) {
            return BASE;
        }
        if (capabilities.GL_ARB_vertex_array_object) {
            return ARB;
        }
        return UNSUPPORTED;
    }

    public abstract void glBindVertexArray(int var1);

    public abstract int glGenVertexArrays();

    public abstract void glDeleteVertexArrays(int var1);
}

